/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NBTTags;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IPos;
import noppes.npcs.api.entity.data.INPCAi;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobBuilder;
import noppes.npcs.roles.JobFarmer;

public class DataAI
implements INPCAi {
    public boolean attackInvisible = false;
    public boolean avoidsSun = false;
    public boolean avoidsWater = false;
    public boolean canLeap = false;
    public boolean canSprint = false;
    public boolean canSwim = true;
    public boolean directLOS = true;
    public boolean movingPause = true;
    public boolean npcInteracting = true;
    public boolean reactsToFire = false;
    public boolean returnToStart = true;
    public boolean stopAndInteract = true;
    public boolean aiDisabled = false;
    public boolean canBeCollide = true;
    public int animationType = 0;
    public int doorInteract = 2;
    public int findShelter = 2;
    public int movementType = 0;
    private int moveSpeed = 5;
    public int movingPattern = 0;
    public int movingPos = 0;
    private int movingType = 0;
    public int onAttack = 0;
    public int orientation = 0;
    private int standingType = 0;
    private int tacticalRadius = 8;
    public int tacticalVariant = 0;
    public int walkingRange = 10;
    private int maxHurtResistantTime = CustomNpcs.DefaultHurtResistantTime * 2;
    public float bodyOffsetX = 5.0f;
    public float bodyOffsetY = 5.0f;
    public float bodyOffsetZ = 5.0f;
    public float stepheight = 0.6f;
    private BlockPos startPos = null;
    private List<int[]> movingPath = new ArrayList<int[]>();
    private final EntityNPCInterface npc;

    public DataAI(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public void appendMovingPath(int[] pos) {
        this.movingPath.add(pos);
    }

    public void clearMovingPath() {
        this.movingPath.clear();
        this.movingPos = 0;
    }

    public void decreaseMovingPath() {
        List<int[]> list = this.getMovingPath();
        if (list.size() == 1) {
            this.movingPos = 0;
            return;
        }
        --this.movingPos;
        if (this.movingPos < 0) {
            if (this.movingPattern == 0) {
                this.movingPos = list.size() - 1;
            } else if (this.movingPattern == 1) {
                this.movingPos = list.size() * 2 - 2;
            }
        }
    }

    @Override
    public int getAnimation() {
        return this.animationType;
    }

    @Override
    public boolean getAttackInvisible() {
        return this.attackInvisible;
    }

    @Override
    public boolean getAttackLOS() {
        return this.directLOS;
    }

    @Override
    public boolean getAvoidsWater() {
        return this.avoidsWater;
    }

    @Override
    public boolean getCanSwim() {
        return this.canSwim;
    }

    @Override
    public int getCurrentAnimation() {
        return this.npc.currentAnimation;
    }

    public int[] getCurrentMovingPath() {
        List<int[]> list = this.getMovingPath();
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        int pos = this.movingPos;
        if (this.movingPattern == 0 && pos >= size) {
            this.movingPos = 0;
            pos = 0;
        } else if (this.movingPattern == 1) {
            int size2 = size * 2 - 1;
            if (pos >= size2) {
                this.movingPos = 0;
                pos = 0;
            } else if (pos >= size) {
                pos = size2 - pos;
            }
        }
        return list.get(pos);
    }

    public double getDistanceSqToPathPoint() {
        int[] pos = this.getCurrentMovingPath();
        return this.npc.func_70092_e((double)pos[0] + 0.5, pos[1], (double)pos[2] + 0.5);
    }

    @Override
    public int getDoorInteract() {
        return this.doorInteract;
    }

    @Override
    public boolean getInteractWithNPCs() {
        return this.npcInteracting;
    }

    @Override
    public boolean getLeapAtTarget() {
        return this.canLeap;
    }

    public List<int[]> getMovingPath() {
        if (this.startPos != null) {
            if (this.movingPath.isEmpty()) {
                this.movingPath.add(this.getStartArray());
            } else {
                int[] arr = this.movingPath.get(0);
                if (arr[0] != this.startPos.func_177958_n() || arr[1] != this.startPos.func_177956_o() || arr[2] != this.startPos.func_177952_p()) {
                    this.movingPath.remove(0);
                    this.movingPath.add(0, this.getStartArray());
                }
            }
        }
        return this.movingPath;
    }

    @Override
    public boolean getMovingPathPauses() {
        return this.movingPause;
    }

    public int[] getMovingPathPos(int m_pos) {
        return this.movingPath.get(m_pos);
    }

    public int getMovingPathSize() {
        return this.movingPath.size();
    }

    @Override
    public int getMovingPathType() {
        return this.movingPattern;
    }

    public int getMovingPos() {
        return this.movingPos;
    }

    @Override
    public int getMovingType() {
        return this.movingType;
    }

    @Override
    public int getNavigationType() {
        return this.movementType;
    }

    @Override
    public int getRetaliateType() {
        return this.onAttack;
    }

    @Override
    public boolean getReturnsHome() {
        return this.returnToStart;
    }

    @Override
    public int getSheltersFrom() {
        return this.findShelter;
    }

    @Override
    public int getStandingType() {
        return this.standingType;
    }

    public int[] getStartArray() {
        BlockPos pos = this.startPos();
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    public IPos getStartPos() {
        return new BlockPosWrapper(this.startPos());
    }

    @Override
    public boolean getStopOnInteract() {
        return this.stopAndInteract;
    }

    @Override
    public int getTacticalRange() {
        return this.tacticalRadius;
    }

    @Override
    public int getTacticalType() {
        return this.tacticalVariant;
    }

    @Override
    public int getWalkingSpeed() {
        return this.moveSpeed;
    }

    @Override
    public int getWanderingRange() {
        return this.walkingRange;
    }

    @Override
    public int getMaxHurtResistantTime() {
        return this.maxHurtResistantTime;
    }

    public void incrementMovingPath() {
        List<int[]> list = this.getMovingPath();
        if (list.size() == 1) {
            this.movingPos = 0;
            return;
        }
        ++this.movingPos;
        if (this.movingPattern == 0) {
            this.movingPos %= list.size();
        } else if (this.movingPattern == 1) {
            int size = list.size() * 2 - 1;
            this.movingPos %= size;
        }
    }

    public void readToNBT(NBTTagCompound compound) {
        this.canSwim = compound.func_74767_n("CanSwim");
        this.reactsToFire = compound.func_74767_n("ReactsToFire");
        this.setAvoidsWater(compound.func_74767_n("AvoidsWater"));
        this.avoidsSun = compound.func_74767_n("AvoidsSun");
        this.returnToStart = compound.func_74767_n("ReturnToStart");
        this.onAttack = compound.func_74762_e("OnAttack");
        this.doorInteract = compound.func_74762_e("DoorInteract");
        this.findShelter = compound.func_74762_e("FindShelter");
        this.directLOS = compound.func_74767_n("DirectLOS");
        this.canLeap = compound.func_74767_n("CanLeap");
        this.aiDisabled = compound.func_74767_n("AIDisabled");
        this.canSprint = compound.func_74767_n("CanSprint");
        if (compound.func_150297_b("CanBeCollide", 1)) {
            this.canBeCollide = compound.func_74767_n("CanBeCollide");
        }
        this.tacticalRadius = compound.func_74762_e("TacticalRadius");
        this.movingPause = compound.func_74767_n("MovingPause");
        this.npcInteracting = compound.func_74767_n("npcInteracting");
        this.stopAndInteract = compound.func_74767_n("stopAndInteract");
        this.movementType = compound.func_74762_e("MovementType");
        this.animationType = compound.func_74762_e("MoveState");
        this.standingType = compound.func_74762_e("StandingState");
        this.movingType = compound.func_74762_e("MovingState");
        this.tacticalVariant = compound.func_74762_e("TacticalVariant");
        this.orientation = compound.func_74762_e("Orientation");
        this.bodyOffsetY = compound.func_74760_g("PositionOffsetY");
        this.bodyOffsetZ = compound.func_74760_g("PositionOffsetZ");
        this.bodyOffsetX = compound.func_74760_g("PositionOffsetX");
        this.stepheight = compound.func_74760_g("StepHeight");
        this.walkingRange = compound.func_74762_e("WalkingRange");
        this.setWalkingSpeed(compound.func_74762_e("MoveSpeed"));
        this.setMovingPath(NBTTags.getIntegerArraySet(compound.func_150295_c("MovingPathNew", 10)));
        this.movingPos = compound.func_74762_e("MovingPos");
        this.movingPattern = compound.func_74762_e("MovingPatern");
        this.attackInvisible = compound.func_74767_n("AttackInvisible");
        if (compound.func_74764_b("StartPosNew")) {
            int[] pos = compound.func_74759_k("StartPosNew");
            this.startPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
        this.npc.field_70138_W = this.stepheight;
        if (this.standingType != 0 && this.standingType != 2) {
            this.npc.func_70034_d(this.orientation);
        }
        if (compound.func_150297_b("MaxHurtResistantTime", 3)) {
            this.maxHurtResistantTime = compound.func_74762_e("MaxHurtResistantTime");
        }
        this.npc.field_70771_an = this.maxHurtResistantTime;
    }

    @Override
    public void setAnimation(int type) {
        this.animationType = type;
    }

    @Override
    public void setAttackInvisible(boolean attack) {
        this.attackInvisible = attack;
    }

    @Override
    public void setAttackLOS(boolean enabled) {
        this.directLOS = enabled;
        this.npc.updateAI = true;
    }

    @Override
    public void setAvoidsWater(boolean enabled) {
        if (this.npc.func_70661_as() instanceof PathNavigateGround) {
            this.npc.func_184644_a(PathNodeType.WATER, enabled ? PathNodeType.WATER.func_186289_a() : 0.0f);
        }
        this.avoidsWater = enabled;
    }

    @Override
    public void setCanSwim(boolean canSwim) {
        this.canSwim = canSwim;
    }

    @Override
    public void setDoorInteract(int type) {
        this.doorInteract = type;
        this.npc.updateAI = true;
    }

    @Override
    public void setInteractWithNPCs(boolean interact) {
        this.npcInteracting = interact;
    }

    @Override
    public void setLeapAtTarget(boolean leap) {
        this.canLeap = leap;
        this.npc.updateAI = true;
    }

    public void setMovingPath(List<int[]> list) {
        this.movingPath = list;
        if (!this.movingPath.isEmpty()) {
            int[] pos = this.movingPath.get(0);
            this.startPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
    }

    public void setMovingPathPos(int m_pos, int[] pos) {
        if (m_pos < 0) {
            m_pos = 0;
        }
        this.movingPath.set(m_pos, pos);
    }

    @Override
    public void setMovingPathType(int type, boolean pauses) {
        if (type != 0 && type != 1) {
            throw new CustomNPCsException("Moving path type: " + type, new Object[0]);
        }
        this.movingPattern = type;
        this.movingPause = pauses;
    }

    public void setMovingPos(int pos) {
        this.movingPos = pos;
    }

    @Override
    public void setMovingType(int type) {
        if (type < 0 || type > 2) {
            throw new CustomNPCsException("Unknown moving type: " + type, new Object[0]);
        }
        this.movingType = type;
        this.npc.updateAI = true;
    }

    @Override
    public void setNavigationType(int type) {
        this.movementType = type;
    }

    @Override
    public void setRetaliateType(int type) {
        if (type < 0 || type > 3) {
            throw new CustomNPCsException("[0 / 3] ]Unknown retaliation type: " + type, new Object[0]);
        }
        this.onAttack = type;
        this.npc.updateAI = true;
    }

    @Override
    public void setReturnsHome(boolean bo) {
        this.returnToStart = bo;
    }

    @Override
    public void setSheltersFrom(int type) {
        this.findShelter = type;
        this.npc.updateAI = true;
    }

    @Override
    public void setStandingType(int type) {
        if (type < 0 || type > 4) {
            throw new CustomNPCsException("Unknown standing type: " + type, new Object[0]);
        }
        this.standingType = type;
        this.npc.updateAI = true;
    }

    public void setStartPos(BlockPos pos) {
        this.startPos = pos;
    }

    public void setStartPos(double x, double y, double z) {
        this.startPos = new BlockPos(x, y, z);
    }

    public void setStartPos(IPos pos) {
        this.startPos = pos.getMCBlockPos();
    }

    @Override
    public void setStopOnInteract(boolean stopOnInteract) {
        this.stopAndInteract = stopOnInteract;
    }

    @Override
    public void setTacticalRange(int range) {
        this.tacticalRadius = range;
    }

    @Override
    public void setTacticalType(int type) {
        this.tacticalVariant = type;
        this.npc.updateAI = true;
    }

    @Override
    public void setWalkingSpeed(int speed) {
        if (speed < 0 || speed > 10) {
            throw new CustomNPCsException("Wrong speed: " + speed, new Object[0]);
        }
        this.moveSpeed = speed;
        this.npc.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.npc.getSpeed());
        this.npc.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a((double)(this.npc.getSpeed() * 2.0f));
    }

    @Override
    public void setWanderingRange(int range) {
        if (range < 1 || range > 50) {
            throw new CustomNPCsException("Bad wandering range: " + range + " (1 - 50)", new Object[0]);
        }
        this.walkingRange = range;
    }

    @Override
    public void setMaxHurtResistantTime(int ticks) {
        if (ticks < 0) {
            ticks *= -1;
        }
        if (ticks > 1200) {
            ticks = 1200;
        }
        this.maxHurtResistantTime = ticks;
    }

    public boolean shouldReturnHome() {
        return !(this.npc.advanced.jobInterface instanceof JobBuilder && ((JobBuilder)this.npc.advanced.jobInterface).isBuilding() || this.npc.advanced.jobInterface instanceof JobFarmer && ((JobFarmer)this.npc.advanced.jobInterface).isPlucking() || !this.returnToStart);
    }

    public BlockPos startPos() {
        if (this.startPos == null) {
            this.startPos = new BlockPos((Entity)this.npc);
        }
        return this.startPos;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        this.setAvoidsWater(this.avoidsWater);
        compound.func_74757_a("CanSwim", this.canSwim);
        compound.func_74757_a("ReactsToFire", this.reactsToFire);
        compound.func_74757_a("AvoidsWater", this.avoidsWater);
        compound.func_74757_a("AvoidsSun", this.avoidsSun);
        compound.func_74757_a("ReturnToStart", this.returnToStart);
        compound.func_74768_a("OnAttack", this.onAttack);
        compound.func_74768_a("DoorInteract", this.doorInteract);
        compound.func_74768_a("FindShelter", this.findShelter);
        compound.func_74757_a("DirectLOS", this.directLOS);
        compound.func_74757_a("CanLeap", this.canLeap);
        compound.func_74757_a("AIDisabled", this.aiDisabled);
        compound.func_74757_a("CanSprint", this.canSprint);
        compound.func_74757_a("CanBeCollide", this.canBeCollide);
        compound.func_74768_a("TacticalRadius", this.tacticalRadius);
        compound.func_74757_a("MovingPause", this.movingPause);
        compound.func_74757_a("npcInteracting", this.npcInteracting);
        compound.func_74757_a("stopAndInteract", this.stopAndInteract);
        compound.func_74768_a("MoveState", this.animationType);
        compound.func_74768_a("StandingState", this.standingType);
        compound.func_74768_a("MovingState", this.movingType);
        compound.func_74768_a("TacticalVariant", this.tacticalVariant);
        compound.func_74768_a("MovementType", this.movementType);
        compound.func_74768_a("Orientation", this.orientation);
        compound.func_74776_a("PositionOffsetX", this.bodyOffsetX);
        compound.func_74776_a("PositionOffsetY", this.bodyOffsetY);
        compound.func_74776_a("PositionOffsetZ", this.bodyOffsetZ);
        compound.func_74776_a("StepHeight", this.stepheight);
        compound.func_74768_a("WalkingRange", this.walkingRange);
        compound.func_74768_a("MoveSpeed", this.moveSpeed);
        compound.func_74782_a("MovingPathNew", (NBTBase)NBTTags.nbtIntegerArraySet(this.movingPath));
        compound.func_74768_a("MovingPos", this.movingPos);
        compound.func_74768_a("MovingPatern", this.movingPattern);
        compound.func_74783_a("StartPosNew", this.getStartArray());
        compound.func_74757_a("AttackInvisible", this.attackInvisible);
        compound.func_74768_a("MaxHurtResistantTime", this.maxHurtResistantTime);
        return compound;
    }

    @Override
    public boolean isAIDisabled() {
        return this.aiDisabled;
    }

    @Override
    public void setIsAIDisabled(boolean bo) {
        this.aiDisabled = bo;
    }

    @Override
    public boolean canBeCollide() {
        return this.canBeCollide;
    }

    @Override
    public void setCanBeCollide(boolean bo) {
        this.canBeCollide = bo;
    }
}

